chrome.runtime.onInstalled.addListener(() => {
    chrome.contextMenus.create({
        id: "format-json",
        title: "Format JSON",
        contexts: ["selection"]
    });

    chrome.contextMenus.create({
        id: "minify-json",
        title: "Minify JSON",
        contexts: ["selection"]
    });
});

chrome.contextMenus.onClicked.addListener((info, tab) => {
    const jsonString = info.selectionText?.trim();
    let queryParam = "";

    if (info.menuItemId === "format-json") {
        queryParam = "?format=true";
    } else if (info.menuItemId === "minify-json") {
        queryParam = "?minify=true";
    }

    if (queryParam && jsonString) {
        chrome.tabs.create({ url: "https://www.codebysde.in/formatter/json-formatter" + queryParam }, (newTab) => {
            chrome.tabs.onUpdated.addListener(function listener(tabId, changeInfo) {
                if (tabId === newTab.id && changeInfo.status === 'complete') {
                    chrome.tabs.onUpdated.removeListener(listener);
                    chrome.scripting.executeScript({
                        target: { tabId: newTab.id },
                        func: (json) => {
                            localStorage.setItem("/json-formatter:inputJson", json);
                        },
                        args: [jsonString]
                    });
                }
            });
        });
    }
});

chrome.action.onClicked.addListener(() => {
    chrome.tabs.create({ url: "https://www.codebysde.in/formatter/json-formatter" });
});
