// Toolbar button click
chrome.action.onClicked.addListener(async (tab) => {
    if (tab.url) {
        const toolUrl = `https://codebysde.in/url-tool/url-pro-analyzer#${tab.url}`;
        chrome.tabs.create({ url: toolUrl });
    } else {
        chrome.tabs.create({ url: "https://codebysde.in/url-tool/url-pro-analyzer" });
    }
});

// Register context menu items
chrome.runtime.onInstalled.addListener(() => {
    chrome.contextMenus.create({
        id: "analyze-selection",
        title: "Analyze Selected Text as URL",
        contexts: ["selection"]
    });

    chrome.contextMenus.create({
        id: "analyze-link",
        title: "Analyze This Link",
        contexts: ["link"]
    });

    chrome.contextMenus.create({
        id: "analyze-page",
        title: "Analyze This Page URL",
        contexts: ["page"]
    });
});

// Handle context menu clicks
chrome.contextMenus.onClicked.addListener((info, tab) => {
    let targetUrl = "";

    if (info.menuItemId === "analyze-selection") {
        targetUrl = info.selectionText;
    } else if (info.menuItemId === "analyze-link") {
        targetUrl = info.linkUrl;
    } else if (info.menuItemId === "analyze-page") {
        targetUrl = tab.url;
    }

    if (targetUrl) {
        const toolUrl = `https://codebysde.in/url-tool/url-pro-analyzer#${targetUrl}`;
        chrome.tabs.create({ url: toolUrl });
    }
});
